"""
HB_ToggleVisibility V1.1

Last Modified:Oct/11/2018
Works with CINEMA 4D R16.050 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_ToggleVisibility
Description-US: Toggle the Visibility of selected Objects

Usage: Preferable used with Shortcut

Video Tutorial:
https://youtu.be/Ki6I9sRdeUU?t=38m50s


ChangeLog:

Jun/11/2015 V1.0
- Release Version

Oct/11/2018 V1.1
- Python Rewrite
- New Highres Icon


"""

import c4d
from c4d import gui

def main():

    activeobjects = doc.GetActiveObjects(c4d.GETACTIVEOBJECTFLAGS_CHILDREN) 

    for obj in activeobjects:
        if obj[c4d.ID_BASEOBJECT_VISIBILITY_EDITOR]==2 or obj[c4d.ID_BASEOBJECT_VISIBILITY_EDITOR]==0:
            obj[c4d.ID_BASEOBJECT_VISIBILITY_EDITOR]=1
        else:
            obj[c4d.ID_BASEOBJECT_VISIBILITY_EDITOR]=2
        obj[c4d.ID_BASEOBJECT_VISIBILITY_RENDER]=obj[c4d.ID_BASEOBJECT_VISIBILITY_EDITOR]
      
    c4d.EventAdd()

    


if __name__=='__main__':
    main()
